#ifndef DICONO_H
    #define DICONO_H

    #include "DObjeto.h"
    #include <shlobj.h>

    enum DEnum_DIcono_Tam {
        DEnum_Icono_Tam_Grande  = 0x000000000, // SHGFI_LARGEICON,
        DEnum_Icono_Tam_Peque   = 0x000000001  //SHGFI_SMALLICON
    };

    namespace DWL {

        class DIcono {
          public :
                            DIcono(void) : _Icono(NULL) { };
                           ~DIcono(void) { if (_Icono != NULL) DestroyIcon(_Icono); };
            inline HICON    Icono(void)  { return _Icono; };
            inline HICON    operator () (void) { return _Icono; };

            void            CargarIconoCSLID(const int CSIDL, const DEnum_DIcono_Tam nTam);
            void            CargarIconoRecursos(const int cID, const int nAncho, const int nAlto);
                            // Funcin que carga el icono asociado al explorador del path especificado
            void            CargarIconoExplorador(const TCHAR *nPath, const DEnum_DIcono_Tam nTam);
                            // Funcin que carga el icono que hay en el path especificado
            void            CargarIcono(const TCHAR *nPath, const int nAncho, const int nAlto);
          protected :
            HICON          _Icono;
        };

    };
#endif